package gov.va.genisis2.dto;

import java.io.Serializable;

import javax.xml.bind.annotation.XmlRootElement;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

/**
 * Data Transfer Object (DTO) to transfer source type related details
 * 
 * @author Prasad Thummalapalli
 *
 */
@XmlRootElement(name = "source")
@JsonIgnoreProperties({ "requests" })
public class SourceDTO implements Serializable {

	/**
	 * serialVersionUID field
	 */
	private static final long serialVersionUID = 55960295776135318L;

	private int id;
	private String description;

	/**
	 * @return the id
	 */
	public int getId() {
		return id;
	}

	/**
	 * @param id
	 *            the id to set
	 */
	public void setId(int id) {
		this.id = id;
	}

	/**
	 * @return the description
	 */
	public String getDescription() {
		return description;
	}

	/**
	 * @param description
	 *            the description to set
	 */
	public void setDescription(String description) {
		this.description = description;
	}
}
